#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include "agg_rendering_buffer.h"
#include "agg_rasterizer_scanline_aa.h"
#include "agg_scanline_p.h"
#include "agg_renderer_scanline.h"
#include "agg_conv_bspline.h"
#include "agg_conv_segmentator.h"
#include "agg_conv_smooth_poly1.h"
#include "ctrl/agg_cbox_ctrl.h"
#include "ctrl/agg_slider_ctrl.h"
#include "platform/agg_platform_support.h"
#include "interactive_polygon.h"

#define AGG_BGR24 
//#define AGG_RGB24
//#define AGG_BGRA32 
//#define AGG_RGBA32 
//#define AGG_ARGB32 
//#define AGG_ABGR32
//#define AGG_RGB565
//#define AGG_RGB555
#include "pixel_formats.h"

enum { flip_y = true };



void average_polyline(agg::path_storage& path, agg::path_storage& path2, unsigned n)
{
    if(path.total_vertices() > 2)
    {
        agg::pod_deque<agg::point_type> tmp;
        unsigned i, j;
        for(j = 0; j < path.total_vertices(); j++)
        {
            double x, y;
            path.vertex(j, &x, &y);
            tmp.add(agg::point_type(x, y));
        }

        for(i = 0; i < n; i++)
        {
            path2.remove_all();
            for(j = 0; j < tmp.size(); j++)
            {
                agg::point_type p(tmp[j].x, tmp[j].y);
                int d = 1;
                if(j) 
                {
                    p.x += tmp[j-1].x;
                    p.y += tmp[j-1].y;
                    ++d;
                }
                if(j + 1 < tmp.size()) 
                {
                    p.x += tmp[j+1].x;
                    p.y += tmp[j+1].y;
                    ++d;
                }
                if(j == 0) path2.move_to(p.x / d, p.y / d);
                else       path2.line_to(p.x / d, p.y / d);
            }

            if(i < n-1)
            {
                tmp.remove_all();
                for(j = 0; j < path2.total_vertices(); j++)
                {
                    double x, y;
                    path2.vertex(j, &x, &y);
                    tmp.add(agg::point_type(x, y));
                }
            }
        }
    }
}



class the_application : public agg::platform_support
{
public:
    typedef agg::renderer_base<pixfmt> renderer_base;
    typedef agg::renderer_scanline_aa_solid<renderer_base> renderer_solid;
    typedef agg::scanline_p8 scanline_type;

    agg::slider_ctrl<agg::rgba8> m_num_points;
    agg::path_storage            m_path;

    the_application(agg::pix_format_e format, bool flip_y) :
        agg::platform_support(format, flip_y),
        m_num_points(5.0, 5.0, 340.0, 12.0, !flip_y)
    {
        m_num_points.range(1, 30.0);
        m_num_points.value(10.0);
        m_num_points.label("Degree = %.0f");
        add_ctrl(m_num_points);
    }


    virtual void on_init()
    {
    }


    virtual void on_draw()
    {
        pixfmt pixf(rbuf_window());
        renderer_base rb(pixf);
        renderer_solid r(rb);
        rb.clear(agg::rgba(1, 1, 1));

        scanline_type sl;
        agg::rasterizer_scanline_aa<> ras;



        typedef agg::conv_stroke<agg::path_storage> stroke_polyline_type;
        stroke_polyline_type stroke_poly(m_path);
        stroke_poly.width(0.3);
        r.color(agg::rgba(0, 0.5, 0.7));
        ras.add_path(stroke_poly);
        agg::render_scanlines(ras, sl, r);

        agg::path_storage path2;
        average_polyline(m_path, path2, int(m_num_points.value()));


        // BSpline
        typedef agg::conv_bspline<agg::path_storage> conv_bspline_type;
        conv_bspline_type bspline(path2);
        bspline.interpolation_step(0.1);
        typedef agg::conv_stroke<conv_bspline_type> conv_stroke_type;
        conv_stroke_type stroke(bspline);

        stroke.width(6.0);
        stroke.line_cap(agg::round_cap);
        stroke.line_join(agg::round_join);
        r.color(agg::rgba(0.8, 0, 0, 0.4));
        ras.add_path(stroke);
        agg::render_scanlines(ras, sl, r);

        agg::render_ctrl(ras, sl, r, m_num_points);
        //--------------------------

    }



    virtual void on_mouse_button_down(int x, int y, unsigned flags)
    {
        if(flags & agg::mouse_left)
        {
            m_path.remove_all();
            m_path.move_to(x, y);
            force_redraw();
        }
    }


    virtual void on_mouse_move(int x, int y, unsigned flags)
    {
        if(flags & agg::mouse_left)
        {
            if(m_path.total_vertices())
            {
                double x1, y1;
                m_path.vertex(m_path.total_vertices() - 1, &x1, &y1);
                double d = agg::calc_distance(x1, y1, x, y);
                const double min_dist = 10.0;
                if(d > min_dist)
                {
                    double k = 0.0;
                    double dd = min_dist / d;
                    while(k < 0.99)
                    {
                        m_path.line_to(x1 + (x - x1) * k, y1 + (y - y1) * k);
                        k += dd;
                    }
                }
            }

            m_path.line_to(x, y);
            force_redraw();
        }
    }


    virtual void on_mouse_button_up(int x, int y, unsigned flags)
    {
        force_redraw();
    }


    virtual void on_key(int x, int y, unsigned key, unsigned flags)
    {
    }

};






int agg_main(int argc, char* argv[])
{
    the_application app(pix_format, flip_y);
    app.caption("AGG Example. BSpline Interpolator");

    if(app.init(800, 400, agg::window_resize))
    {
        return app.run();
    }
    return 1;
}










